/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.integrator;

import filenet.vw.api.VWException;
import filenet.vw.api.VWQueueDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.property.integrator.IVWPanelInterface;
import filenet.vw.toolkit.admin.property.integrator.VWAdaptorInfo;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class VWGeneralPanel
extends JPanel
implements IVWPanelInterface {
    private JTextField m_nameTextField = null;
    private JTextArea m_descriptionTextArea = null;

    public VWGeneralPanel(VWAdaptorInfo adaptorInfo) {
        this.initialize(adaptorInfo);
    }

    public String getDescription() {
        if (this.m_descriptionTextArea != null) {
            return this.m_descriptionTextArea.getText();
        }
        return null;
    }

    public String getName() {
        if (this.m_nameTextField != null) {
            return this.m_nameTextField.getText();
        }
        return null;
    }

    public void releaseResources() {
        if (this.m_nameTextField != null) {
            this.m_nameTextField.removeAll();
            this.m_nameTextField = null;
        }
        if (this.m_descriptionTextArea != null) {
            this.m_descriptionTextArea.removeAll();
            this.m_descriptionTextArea = null;
        }
    }

    public void checkForErrors() throws Exception {
        String name = this.getName();
        if (name == null || name.length() < 1) {
            throw new VWException("vw.toolkit.admin.property.integrator.VWGeneralPanel.invalidName", "You must specify a valid name.");
        }
    }

    public String getInstructions() {
        return VWResource.DefineANewComponent;
    }

    public JComponent getInitialFocusComponent() {
        return this.m_nameTextField;
    }

    private void initialize(VWAdaptorInfo adaptorInfo) {
        String name = null;
        String description = null;
        try {
            VWQueueDefinition vwQueueDef;
            if (adaptorInfo != null && (vwQueueDef = adaptorInfo.getQueueDefinition()) != null) {
                name = vwQueueDef.getName();
                description = vwQueueDef.getDescription();
            }
            this.createControls(name, description);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void createControls(String name, String description) {
        try {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridwidth = -1;
            gbCons.anchor = 23;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(6, 6, 6, 6);
            JLabel label = new JLabel(VWResource.Colon.toString(VWResource.QueueName));
            VWAccessibilityHelper.setAccessibility(label, this, VWResource.QueueName, VWResource.QueueName);
            this.add((Component)label, gbCons);
            gbCons.gridwidth = 0;
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            this.m_nameTextField = new JTextField();
            if (name != null) {
                this.m_nameTextField.setText(name);
                this.m_nameTextField.setEditable(false);
            }
            VWAccessibilityHelper.setAccessibility(this.m_nameTextField, this, VWResource.QueueNameTextField, VWResource.QueueNameTextField);
            VWAccessibilityHelper.setLabelFor(label, this.m_nameTextField);
            this.add((Component)this.m_nameTextField, gbCons);
            gbCons.gridwidth = -1;
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            label = new JLabel(VWResource.Colon.toString(VWResource.QueueType));
            VWAccessibilityHelper.setAccessibility(label, this, VWResource.QueueType, VWResource.QueueType);
            this.add((Component)label, gbCons);
            gbCons.gridwidth = 0;
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            JLabel component = new JLabel(VWResource.Component);
            this.add((Component)component, gbCons);
            VWAccessibilityHelper.setAccessibility(component, this, VWResource.Component, VWResource.Component);
            gbCons.gridwidth = -1;
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            label = new JLabel(VWResource.Colon.toString(VWResource.Description));
            this.add((Component)label, gbCons);
            VWAccessibilityHelper.setAccessibility(label, this, VWResource.Description, VWResource.Description);
            gbCons.gridwidth = 0;
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.fill = 1;
            gbCons.weightx = 1.0;
            gbCons.weighty = 1.0;
            this.m_descriptionTextArea = new JTextArea();
            this.m_descriptionTextArea.setLineWrap(true);
            this.m_descriptionTextArea.setWrapStyleWord(true);
            if (description != null) {
                this.m_descriptionTextArea.setText(description);
            }
            VWAccessibilityHelper.setAccessibility(this.m_descriptionTextArea, this, VWResource.DescriptionTextArea, VWResource.DescriptionTextArea);
            VWAccessibilityHelper.setLabelFor(label, this.m_descriptionTextArea);
            this.add((Component)new JScrollPane(this.m_descriptionTextArea), gbCons);
            this.m_nameTextField.requestFocus();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

